# Руководство по использованию инструментов для локализации

## Краткий обзор скриптов

- **`run_lupdate.py`** - Сканирует исходный код и обновляет .ts файлы с новыми строками для перевода
- **`run_lrelease.py`** - Компилирует .ts файлы в бинарные .qm файлы для использования в приложении
- **`llm_translator/extract_strings.py`** - Извлекает непереведенные строки из .ts файла в текстовый файл
- **`llm_translator/insert_translations.py`** - Вставляет переводы из текстового файла обратно в .ts файл
- **`llm_translator/fix_unfinished_translations.py`** - Исправляет статус переведенных строк, удаляя атрибут "unfinished"

Этот документ описывает, как использовать скрипты в директории `i18n/tools` для управления файлами локализации проекта.

## Обзор

Процесс локализации состоит из нескольких этапов:
1.  **Обновление исходных файлов перевода (`.ts`)**: Сбор всех текстовых строк, требующих перевода, из исходного кода проекта.
2.  **Перевод строк**: Непосредственно перевод текста на целевые языки.
3.  **Компиляция файлов перевода (`.qm`)**: Преобразование `.ts` файлов в бинарный формат `.qm`, который используется приложением.

Для автоматизации этих процессов предназначены следующие скрипты.

---

## Стандартные инструменты Qt

Эти скрипты являются обертками для стандартных утилит Qt (`lupdate` и `lrelease`).

### `run_lupdate.py`

**Назначение:**
Сканирует исходный код проекта на наличие строк, обернутых в `tr()`, и обновляет файлы `ru_RU_auto.ts` и `en_US_auto.ts`. Добавляет новые строки и помечает устаревшие, если они больше не используются в коде (с опцией `-no-obsolete` устаревшие строки удаляются).

**Как использовать:**
Запустите скрипт из корневой директории проекта:
```powershell
python i18n/tools/run_lupdate.py
```
Скрипт автоматически найдет все `.py` файлы, исключая те, что указаны в `.gitignore` и некоторые системные папки, и обновит `.ts` файлы.

### `run_lrelease.py`

**Назначение:**
Компилирует текстовые файлы `.ts` в бинарные файлы `.qm`. Приложение использует именно `.qm` файлы для отображения переведенного интерфейса.

**Как использовать:**
Запустите скрипт после того, как все переводы в `.ts` файлах будут готовы:
```powershell
python i18n/tools/run_lrelease.py
```
Скрипт создаст или обновит файлы `ru_RU_auto.qm` и `en_US_auto.qm` в директории `i18n`.

---

## Инструменты для автоматического перевода (`llm_translator`)

Эта группа инструментов предназначена для упрощения процесса перевода с использованием больших языковых моделей (LLM) или для пакетного перевода вручную.

### Рабочий процесс

#### Шаг 1: Извлечение строк для перевода

**Скрипт:** `llm_translator/extract_strings.py`

**Назначение:**
Извлекает все непереведенные строки (теги `<translation>` с атрибутом `type="unfinished"` или пустые) из указанного `.ts` файла и сохраняет их в `for_translation.txt` в той же директории. Каждая строка нумеруется для удобства отслеживания.

**Как использовать:**
```powershell
python i18n/tools/llm_translator/extract_strings.py
```
По умолчанию скрипт работает с `i18n/en_US_auto.ts`.

#### Шаг 2: Перевод строк

После выполнения `extract_strings.py` у вас будет файл `for_translation.txt`. Его необходимо перевести. Результат перевода нужно сохранить в файл `translated.txt` в той же директории (`llm_translator`), сохраняя исходную нумерацию строк.

**Пример:**

`for_translation.txt`:
```
1: Open File
2: Save Project
```

`translated.txt` (для русского языка):
```
1: Открыть файл
2: Сохранить проект
```

#### Шаг 3: Вставка переводов

**Скрипт:** `llm_translator/insert_translations.py`

**Назначение:**
Считывает переводы из `translated.txt` и вставляет их в соответствующий `.ts` файл, обновляя его. Атрибут `type="unfinished"` у переведенных строк удаляется.

**Как использовать:**
```powershell
python i18n/tools/llm_translator/insert_translations.py
```

### Вспомогательный инструмент

**Скрипт:** `llm_translator/fix_unfinished_translations.py`

**Назначение:**
Иногда `.ts` файл может содержать строки с уже готовым переводом, но они по-прежнему помечены как `type="unfinished"`. Этот скрипт проходит по всему файлу и удаляет этот атрибут у всех тегов `<translation>`, которые содержат текст.

**Как использовать:**
Передайте путь к `.ts` файлу в качестве аргумента командной строки:
```powershell
python i18n/tools/llm_translator/fix_unfinished_translations.py i18n/en_US_auto.ts
```

---

## Полный цикл локализации

1.  **Обновите источники:** `python i18n/tools/run_lupdate.py`
2.  **Извлеките строки для перевода:** `python i18n/tools/llm_translator/extract_strings.py`
3.  **Переведите** `for_translation.txt` и сохраните результат в `translated.txt`.
4.  **Вставьте переводы:** `python i18n/tools/llm_translator/insert_translations.py`
5.  **(Опционально) Исправьте статусы:** `python i18n/tools/llm_translator/fix_unfinished_translations.py i18n/en_US_auto.ts`
6.  **Скомпилируйте переводы для приложения:** `python i18n/tools/run_lrelease.py`